import React, {Component} from 'react';
import {graphql, compose} from "react-apollo";
import {Form, TextArea} from 'react-form';
import {userQuery} from "../../../../api/queries";
import Loading from "../../../../core/Loading/Loading";
import moment from 'moment';
import 'moment/locale/it';


class Detail extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

    componentWillMount() {
        moment.locale("it");
    }

    render() {
        const {data} = this.props;

        if(data.loading) {
            return(<Loading/>);
        }

        const {
            utente
        } = data;

        return (<div className="container" style={{marginBottom: '20px'}}>
            <div>
                <div className="row">
                    <div className="col">
                        <h5>Informazioni Generali</h5>
                    </div>
                </div>
                <dl className="row">
                    <dt className="col-sm-3">
                        ID
                    </dt>
                    <dd className="col-sm-9">
                        {utente.id}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Nome
                    </dt>
                    <dd className="col-sm-9">
                        {utente.nome}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Cognome
                    </dt>
                    <dd className="col-sm-9">
                        {utente.cognome}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        E-mail
                    </dt>
                    <dd className="col-sm-9">
                        {utente.email}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Ruolo
                    </dt>
                    <dd className="col-sm-9">
                        {utente.ruolo.nomeEsteso}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Data Scadenza Account
                    </dt>
                    <dd className="col-sm-9">
                        {utente.scadenzaAccount}
                    </dd>
                </dl>
            </div>
        </div>);
    }
}

export default compose(
    graphql(userQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    }),
)(Detail);

Detail.defaultProps = {};

Detail.propTypes = {};